--[[
http://legion.itzg.pl/mzgb/pmwiki/pmwiki.php?n=JaggedAlliance2UBV1.Jav113lua

**********************
** Global variables **
**********************

	- newDIFFICULTY_LEVEL (Start new game setting)
		1 = easy
		2 = experienced
		3 = expert
		4 = insane
        
	- newGAME_STYLE (Start new game setting)
		0 = realistic
		1 = sci fi
        
	- is_networked (Multiplayer)
		0 = no
		1 = yes
        
	- iniENABLE_CREPITUS (ja2_options.ini setting)
		0 = no
		1 = yes
        
	- iniSTARTING_CASH_NOVICE, iniSTARTING_CASH_EXPERIENCED, iniSTARTING_CASH_EXPERT, iniSTARTING_CASH_INSANE (ja2_options.ini setting)
		Starting cash
      
	- iniMERC_WEBSITE_IMMEDIATELY_AVAILABLE (ja2_options.ini setting)
		true = yes
		false = no

	- giHospitalTempBalance
		set hospital balance

	- gbHospitalPriceModifier
		set hospital modifier

	- giHospitalRefund


***************		  
** Functions **
***************
          
	- AddAlternateSector, AddAltSector, AddAltSectorNew 
		add alternative sector
	
	- AddNPC or AddNPCtoSector
		add NPC\EPC\RPC to sector
	
	- AddAltUnderGroundSector, AddAltUGSector or AddAltUGSectorNew
		add alternative underground sector
	
	- SetNPCData1 ( ProfilID, value )
		set NPCData1
	
	- GetStartingCashNovice()
		get starting cash novice level
	
	- GetStartingCashExperienced()
		get starting cash experienced level
	 
	- GetStartingCashExpert()
		get starting cash expert level
	  
	- GetStartingCashInsane()
		get starting cash insane level
	
	- GetWorldTotalMin()
		get world time
	
	- AddTransactionToPlayersBook(ubCode, ubSecondCode, uiDate, iAmount)
		add transaction to player
	
	- AddPreReadEmail (iMessageOffset, iMessageLength, ubSender)
		iMessageOffset - record from email.edt
		iMessageLength - record from email.edt
		ubSender - uiIndex from SenderNameList.xml 
	
	- AddEmail (iMessageOffset, iMessageLength, ubSender, iCurrentIMPPosition, iCurrentShipmentDestinationID)
		iMessageOffset - record from email.edt
		iMessageLength - record from email.edt
		ubSender - uiIndex from SenderNameList.xml
		iCurrentIMPPosition - Default = -1, or the profile ID of the IMP 
		iCurrentShipmentDestinationID - Default = -1, or the Bobby Ray shipment destination ID
	
	- HireMerc (MercID)
		hires the merc with the specified MercID


**************        
** Examples **
**************

    -- Add Fatima to sector
    Fatima = { }
    Fatima.MercProfiles = 101
    Fatima.sector = "A10-0"
    AddNPC(Fatima)
    
    -- Add Fatima to sector
    AddNPC( { MercProfiles = 101 , sector = "A10-0" } )
    
	-- Add Fatima to sector, only in a realistic game
	if newGAME_STYLE == 0 then
	    Fatima = { }
	    Fatima.MercProfiles = 101
	    Fatima.sector = "A10-0"
	    AddNPC(Fatima)
	end
	    
	-- Add alternative sector, only when starting cash = 4000 and game style SciFi
	if (iniSTARTING_CASH_NOVICE == 4000 and newGAME_STYLE == 1) then
	    Fatima = { }
	    Fatima.MercProfiles = 101
	    Fatima.sector = "A10-0"
	    AddNPC(Fatima)
	end
	
	-- Add alternative sector, only realistic game
	if newGAME_STYLE == 0 then
	    SectorA9 = { }
	    SectorA9.altSector = "A9"
	    AddAlternateSector(SectorA9)
	end
	
	-- Add alternative sector
	SectorA9 = { }
	SectorA9.altSector = "A9"
	AddAlternateSector(SectorA9)
	
	-- Add alternative underground sector
	A10_b1 = { }
	A10_b1.altSector = "A10-1"
	AddAltUGSector(A10_b1)	
	
	-- Add alternative underground sector
	AddAltUGSector( { altSector = "A10-1" } )	
	
	    -- Add Skyrider to sector
	AddNPCtoSector(97,9,1,0)
	
	-- Add alternative sector C1
	AddAltSectorNew (3,1)
	
	-- Add alternative sector C1-3
	AddAltUGSectorNew(3,1,3)
	
	-- Hire Ivan
	HireMerc(7)
]]

-- max number of lines can be shown in a message
local MAX_EMAIL_LINES = 10
-- max number of messages per page	
local MAX_MESSAGES_PAGE = 18 	

local IMP_EMAIL_INTRO = 0
local IMP_EMAIL_INTRO_LENGTH = 10
local ENRICO_CONGRATS = (IMP_EMAIL_INTRO + IMP_EMAIL_INTRO_LENGTH)					
local ENRICO_CONGRATS_LENGTH = 3
local IMP_EMAIL_AGAIN = (ENRICO_CONGRATS + ENRICO_CONGRATS_LENGTH)
local IMP_EMAIL_AGAIN_LENGTH = 6
local MERC_INTRO = (IMP_EMAIL_AGAIN + IMP_EMAIL_AGAIN_LENGTH)
local MERC_INTRO_LENGTH = 5
local MERC_NEW_SITE_ADDRESS = ( MERC_INTRO + MERC_INTRO_LENGTH )
local MERC_NEW_SITE_ADDRESS_LENGTH = 2
local AIM_MEDICAL_DEPOSIT_REFUND = ( MERC_NEW_SITE_ADDRESS + MERC_NEW_SITE_ADDRESS_LENGTH )
local AIM_MEDICAL_DEPOSIT_REFUND_LENGTH = 3
local IMP_EMAIL_PROFILE_RESULTS = ( AIM_MEDICAL_DEPOSIT_REFUND + AIM_MEDICAL_DEPOSIT_REFUND_LENGTH )
local IMP_EMAIL_PROFILE_RESULTS_LENGTH = 1
local MERC_WARNING = ( IMP_EMAIL_PROFILE_RESULTS_LENGTH + IMP_EMAIL_PROFILE_RESULTS )
local MERC_WARNING_LENGTH = 2
local MERC_INVALID = ( MERC_WARNING + MERC_WARNING_LENGTH )
local MERC_INVALID_LENGTH = 2							
local NEW_MERCS_AT_MERC = ( MERC_INVALID + MERC_INVALID_LENGTH )
local NEW_MERCS_AT_MERC_LENGTH = 2
local MERC_FIRST_WARNING = ( NEW_MERCS_AT_MERC + NEW_MERCS_AT_MERC_LENGTH )
local MERC_FIRST_WARNING_LENGTH = 2

-- merc up a level emails
local MERC_UP_LEVEL_BIFF = ( MERC_FIRST_WARNING + MERC_FIRST_WARNING_LENGTH )
local MERC_UP_LEVEL_LENGTH_BIFF = 2
local MERC_UP_LEVEL_HAYWIRE	 = ( MERC_UP_LEVEL_LENGTH_BIFF + MERC_UP_LEVEL_BIFF )
local MERC_UP_LEVEL_LENGTH_HAYWIRE = 2
local MERC_UP_LEVEL_GASKET = ( MERC_UP_LEVEL_LENGTH_HAYWIRE + MERC_UP_LEVEL_HAYWIRE )
local MERC_UP_LEVEL_LENGTH_GASKET = 2
local MERC_UP_LEVEL_RAZOR = ( MERC_UP_LEVEL_LENGTH_GASKET + MERC_UP_LEVEL_GASKET )
local MERC_UP_LEVEL_LENGTH_RAZOR = 2
local MERC_UP_LEVEL_FLO	 = ( MERC_UP_LEVEL_LENGTH_RAZOR + MERC_UP_LEVEL_RAZOR )
local MERC_UP_LEVEL_LENGTH_FLO = 2
local MERC_UP_LEVEL_GUMPY = ( MERC_UP_LEVEL_LENGTH_FLO + MERC_UP_LEVEL_FLO )
local MERC_UP_LEVEL_LENGTH_GUMPY = 2
local MERC_UP_LEVEL_LARRY = ( MERC_UP_LEVEL_LENGTH_GUMPY + MERC_UP_LEVEL_GUMPY )
local MERC_UP_LEVEL_LENGTH_LARRY = 2
local MERC_UP_LEVEL_COUGAR = ( MERC_UP_LEVEL_LENGTH_LARRY + MERC_UP_LEVEL_LARRY )
local MERC_UP_LEVEL_LENGTH_COUGAR = 2
local MERC_UP_LEVEL_NUMB = ( MERC_UP_LEVEL_LENGTH_COUGAR + MERC_UP_LEVEL_COUGAR )
local MERC_UP_LEVEL_LENGTH_NUMB = 2
local MERC_UP_LEVEL_BUBBA = ( MERC_UP_LEVEL_LENGTH_NUMB + MERC_UP_LEVEL_NUMB )
local MERC_UP_LEVEL_LENGTH_BUBBA = 2

-- merc left-me-a-message-and-now-I'm-back emails
local AIM_REPLY_BARRY = ( MERC_UP_LEVEL_LENGTH_BUBBA + MERC_UP_LEVEL_BUBBA )
local AIM_REPLY_LENGTH_BARRY = 2
local AIM_REPLY_MELTDOWN = (AIM_REPLY_BARRY + ( 39 * AIM_REPLY_LENGTH_BARRY ))
local AIM_REPLY_LENGTH_MELTDOWN	 = AIM_REPLY_LENGTH_BARRY

-- old EXISTING emails when player starts game. They must look "read"
local OLD_ENRICO_1 = ( AIM_REPLY_LENGTH_MELTDOWN + AIM_REPLY_MELTDOWN )
local OLD_ENRICO_1_LENGTH = 3
local OLD_ENRICO_2 = ( OLD_ENRICO_1 + OLD_ENRICO_1_LENGTH )
local OLD_ENRICO_2_LENGTH = 3
local RIS_REPORT = ( OLD_ENRICO_2 + OLD_ENRICO_2_LENGTH )
local RIS_REPORT_LENGTH	 = 2
local OLD_ENRICO_3 = ( RIS_REPORT + RIS_REPORT_LENGTH )
local OLD_ENRICO_3_LENGTH = 3

-- emails that occur from Enrico once player accomplishes things
local ENRICO_MIGUEL = ( OLD_ENRICO_3 + OLD_ENRICO_3_LENGTH )
local ENRICO_MIGUEL_LENGTH = 3
local ENRICO_PROG_20 = ( ENRICO_MIGUEL + ENRICO_MIGUEL_LENGTH )
local ENRICO_PROG_20_LENGTH = 3
local ENRICO_PROG_55 = ( ENRICO_PROG_20 + ENRICO_PROG_20_LENGTH )
local ENRICO_PROG_55_LENGTH = 3
local ENRICO_PROG_80 = ( ENRICO_PROG_55 + ENRICO_PROG_55_LENGTH )
local ENRICO_PROG_80_LENGTH = 3
local ENRICO_SETBACK = ( ENRICO_PROG_80 + ENRICO_PROG_80_LENGTH )
local ENRICO_SETBACK_LENGTH = 3
local ENRICO_SETBACK_2 = ( ENRICO_SETBACK + ENRICO_SETBACK_LENGTH )
local ENRICO_SETBACK_2_LENGTH = 3
local ENRICO_CREATURES = ( ENRICO_SETBACK_2 + ENRICO_SETBACK_2_LENGTH )
local ENRICO_CREATURES_LENGTH = 3

-- insurance company emails
local INSUR_PAYMENT = ( ENRICO_CREATURES + ENRICO_CREATURES_LENGTH )
local INSUR_PAYMENT_LENGTH = 3
local INSUR_SUSPIC = ( INSUR_PAYMENT + INSUR_PAYMENT_LENGTH )
local INSUR_SUSPIC_LENGTH = 3
local INSUR_INVEST_OVER	 = ( INSUR_SUSPIC + INSUR_SUSPIC_LENGTH )
local INSUR_INVEST_OVER_LENGTH = 3
local INSUR_SUSPIC_2 = ( INSUR_INVEST_OVER + INSUR_INVEST_OVER_LENGTH )
local INSUR_SUSPIC_2_LENGTH	 = 3

local BOBBYR_NOW_OPEN = ( INSUR_SUSPIC_2 + INSUR_SUSPIC_2_LENGTH )
local BOBBYR_NOW_OPEN_LENGTH = 3

local KING_PIN_LETTER = ( BOBBYR_NOW_OPEN + BOBBYR_NOW_OPEN_LENGTH )
local KING_PIN_LETTER_LENGTH = 4

local LACK_PLAYER_PROGRESS_1 = ( KING_PIN_LETTER + KING_PIN_LETTER_LENGTH )
local LACK_PLAYER_PROGRESS_1_LENGTH = 3

local LACK_PLAYER_PROGRESS_2 = ( LACK_PLAYER_PROGRESS_1 + LACK_PLAYER_PROGRESS_1_LENGTH )
local LACK_PLAYER_PROGRESS_2_LENGTH = 3

local LACK_PLAYER_PROGRESS_3 = ( LACK_PLAYER_PROGRESS_2 + LACK_PLAYER_PROGRESS_2_LENGTH )
local LACK_PLAYER_PROGRESS_3_LENGTH = 3

-- A package from Bobby Ray has arrived in Drassen
local BOBBYR_SHIPMENT_ARRIVED = ( LACK_PLAYER_PROGRESS_3 + LACK_PLAYER_PROGRESS_3_LENGTH )
local BOBBYR_SHIPMENT_ARRIVED_LENGTH = 4

-- John Kulba has left the gifts for the players in Drassen
local JOHN_KULBA_GIFT_IN_DRASSEN = ( BOBBYR_SHIPMENT_ARRIVED + BOBBYR_SHIPMENT_ARRIVED_LENGTH )
local JOHN_KULBA_GIFT_IN_DRASSEN_LENGTH = 4

-- When a merc dies on ANOTHER assignment ( ie not with the player )
local MERC_DIED_ON_OTHER_ASSIGNMENT = ( JOHN_KULBA_GIFT_IN_DRASSEN + JOHN_KULBA_GIFT_IN_DRASSEN_LENGTH )
local MERC_DIED_ON_OTHER_ASSIGNMENT_LENGTH = 5

local INSUR_1HOUR_FRAUD = ( MERC_DIED_ON_OTHER_ASSIGNMENT + MERC_DIED_ON_OTHER_ASSIGNMENT_LENGTH )
local INSUR_1HOUR_FRAUD_LENGTH = 3

-- When a merc is fired, and is injured
local AIM_MEDICAL_DEPOSIT_PARTIAL_REFUND = ( INSUR_1HOUR_FRAUD + INSUR_1HOUR_FRAUD_LENGTH )
local AIM_MEDICAL_DEPOSIT_PARTIAL_REFUND_LENGTH = 3

-- When a merc is fired, and is dead
local AIM_MEDICAL_DEPOSIT_NO_REFUND = ( AIM_MEDICAL_DEPOSIT_PARTIAL_REFUND + AIM_MEDICAL_DEPOSIT_PARTIAL_REFUND_LENGTH )
local AIM_MEDICAL_DEPOSIT_NO_REFUND_LENGTH = 3

local BOBBY_R_MEDUNA_SHIPMENT	 = 	( AIM_MEDICAL_DEPOSIT_NO_REFUND + AIM_MEDICAL_DEPOSIT_NO_REFUND_LENGTH )
local BOBBY_R_MEDUNA_SHIPMENT_LENGTH = 	4

local iStartingCash = 0

local LEGION2_HARD = false

Fincances = 
{
	ACCRUED_INTEREST = 0,
	ANONYMOUS_DEPOSIT = 1,
	TRANSACTION_FEE = 2,
	HIRED_MERC = 3,
	BOBBYR_PURCHASE,
	PAY_SPECK_FOR_MERC = 4,
	MEDICAL_DEPOSIT = 5,
	IMP_PROFILE = 6,
	PURCHASED_INSURANCE = 7,
	REDUCED_INSURANCE = 8,
	EXTENDED_INSURANCE = 9,
	CANCELLED_INSURANCE = 10,
	INSURANCE_PAYOUT = 11,
	EXTENDED_CONTRACT_BY_1_DAY = 12,
	EXTENDED_CONTRACT_BY_1_WEEK = 13,
	EXTENDED_CONTRACT_BY_2_WEEKS = 14,
	DEPOSIT_FROM_GOLD_MINE = 15,
	DEPOSIT_FROM_SILVER_MINE = 16,
	PURCHASED_FLOWERS = 17,
	FULL_MEDICAL_REFUND = 18,
	PARTIAL_MEDICAL_REFUND = 19,
	NO_MEDICAL_REFUND = 20,
	PAYMENT_TO_NPC = 21,
	TRANSFER_FUNDS_TO_MERC = 22,
	TRANSFER_FUNDS_FROM_MERC = 23,
	TRAIN_TOWN_MILITIA = 24,
	PURCHASED_ITEM_FROM_DEALER = 25,
	MERC_DEPOSITED_MONEY_TO_PLAYER_ACCOUNT = 26,
	SOLD_ITEMS = 27,
	FACILITY_OPERATIONS = 28, 	
	MILITIA_UPKEEP = 29, 		
}

Sender = 
{
	MAIL_ENRICO = 0,
	CHAR_PROFILE_SITE = 1,
	GAME_HELP = 2,
	IMP_PROFILE_RESULTS = 3,
	SPECK_FROM_MERC = 4,
	RIS_EMAIL = 5,
	BARRY_MAIL = 6,
	INSURANCE_COMPANY = 46,
	BOBBY_R = 47,
	KING_PIN = 48,
	JOHN_KULBA = 49,
	AIM_SITE = 50,
}

 Modifier = 
 {  
    HOSPITAL_UNSET = 0,
    HOSPITAL_NORMAL = 1,
    HOSPITAL_BREAK = 2,
    HOSPITAL_COST = 3,
    HOSPITAL_FREEBIE = 4,
    HOSPITAL_RANDOM_FREEBIE = 5,
}

SectorY = 
{
	MAP_ROW_A = 1,
	MAP_ROW_B = 2,
	MAP_ROW_C = 3,
	MAP_ROW_D = 4,
	MAP_ROW_E = 5,
	MAP_ROW_F = 6,
	MAP_ROW_G = 7,
	MAP_ROW_H = 8,
	MAP_ROW_I = 9,
	MAP_ROW_J = 10,
	MAP_ROW_K = 11,
	MAP_ROW_L = 12,
	MAP_ROW_M = 13,
	MAP_ROW_N = 14,
	MAP_ROW_O = 15,
	MAP_ROW_P = 16,
}


qStatus = {
            QUESTNOTSTARTED = 0,
            QUESTINPROGRESS = 1,
            QUESTDONE = 2,
          }

Profil = 
{
	Skyrider = 97,
	Micky = 96,
	Gabby = 104,
	Bob = 84,
	Devin = 61,
}

AltIniFile = 
{
	None = 0,
	Alt_A = 1,
	Alt_B = 2,
	Alt_C = 3,
	Alt_D = 4,
}

local DIF_LEVEL_EASY = 1
local DIF_LEVEL_MEDIUM = 2
local DIF_LEVEL_HARD = 3
local DIF_LEVEL_INSANE = 4

Facts = 
{
	FACT_ILOSC_DNI_DO_KONCA_15 = 385,
	FACT_ILOSC_DNI_DO_KONCA_25 = 386,
	FACT_ILOSC_DNI_DO_KONCA_30 = 387,
	FACT_ILOSC_DNI_DO_KONCA_40 = 388,
	FACT_ILOSC_DNI_STOP = 389,
}

local WYL_LAPTOP = false

local iErners = 4000

local function AddBloodCats()
	-- K3
	Legion2_SetNumberOfBloodCatsInSector ( 3, 11, 12, 12 ) 
	
	-- C13
	Legion2_SetNumberOfBloodCatsInSector ( 13, 3, 14, 14 ) 
end

local function ResetNPCSector()

	for a=0,254 do
		SetCharacterTown( a, 0 )
	end
	
	AddNPCtoSector(58 ,0 ,0 ,0)
	AddNPCtoSector(61 ,0 ,0 ,0)
	AddNPCtoSector(62 ,0 ,0 ,0)
	AddNPCtoSector(63 ,0 ,0 ,0)
	AddNPCtoSector(64 ,0 ,0 ,0)
	AddNPCtoSector(65 ,0 ,0 ,0)
	AddNPCtoSector(68 ,0 ,0 ,0)
	AddNPCtoSector(71 ,0 ,0 ,0)
	AddNPCtoSector(74 ,0 ,0 ,0)
	AddNPCtoSector(76 ,0 ,0 ,0)
	AddNPCtoSector(77 ,0 ,0 ,0)
	AddNPCtoSector(78 ,0 ,0 ,0)
	AddNPCtoSector(79 ,0 ,0 ,0)
	AddNPCtoSector(84 ,0 ,0 ,0)
	AddNPCtoSector(85 ,0 ,0 ,0)
	AddNPCtoSector(87 ,0 ,0 ,0)
	AddNPCtoSector(89 ,0 ,0 ,0)
	AddNPCtoSector(92 ,0 ,0 ,0)
	AddNPCtoSector(94 ,0 ,0 ,0)
	AddNPCtoSector(95 ,0 ,0 ,0)
	AddNPCtoSector(96 ,0 ,0 ,0)
	AddNPCtoSector(98 ,0 ,0 ,0)
	AddNPCtoSector(99 ,0 ,0 ,0)
	AddNPCtoSector(109 ,0 ,0 ,0)
	AddNPCtoSector(126 ,0 ,0 ,0)
	AddNPCtoSector(127 ,0 ,0 ,0)
	AddNPCtoSector(128 ,0 ,0 ,0)
	AddNPCtoSector(131 ,0 ,0 ,0)
	AddNPCtoSector(134 ,0 ,0 ,0)
	AddNPCtoSector(135 ,0 ,0 ,0)
	AddNPCtoSector(146 ,0 ,0 ,0)
	AddNPCtoSector(149 ,0 ,0 ,0)
	AddNPCtoSector(151 ,0 ,0 ,0)
	AddNPCtoSector(152 ,0 ,0 ,0)
	AddNPCtoSector(154 ,0 ,0 ,0)
	AddNPCtoSector(155 ,0 ,0 ,0)
	AddNPCtoSector(156 ,0 ,0 ,0)
	AddNPCtoSector(157 ,0 ,0 ,0)
	AddNPCtoSector(158 ,0 ,0 ,0)
end

-- funkcje tylko do modyfikacji Legion 2
-- Legion2_SetTacticalStatusGroupAttack(sector,group,boolean)
-- Legion2_SetSoundProfile(ProfilID,BOOLEAN)

local function SetValue()

	-- Ustaw zapłatę za uprowadzoną wersja 1 - $ Sektor P4
	SetGlobalVal(102,70000)
	
	-- Ustaw zapłatę za uprowadzoną wersja 2 - $ Sektor L1
	SetGlobalVal(103,120000)
	
	-- Zapłata za aresztowanych $
	SetGlobalVal(104,5000)
	
	-- Zapłata za przejscie $
	SetGlobalVal(105,8000)
	
	-- Zapłata Spike 6000$
	SetGlobalVal(106,6000)
	
	-- Zapłata Haker $
	SetGlobalVal(107,7500)
	
	-- Zapłata Bobi $
	SetGlobalVal(108,5500)
	
	-- Zapłata Ernest $
	iErners = math.random(3500, 4500)
	SetGlobalVal( 110,4500 + iErners )
	
	-- Zapłata 97 $
	SetGlobalVal(111,3500)
	
	-- Zapłata 139 Dr. Clifo $
	SetGlobalVal(112,2500)
	
	-- Zapłata 107 Ksenia $
	SetGlobalVal(113,2570)

	-- Ustaw automatycznie brak plików dzwiękowych dla wybranych profili.
	Legion2_SetSoundProfile(57,false)
	Legion2_SetSoundProfile(59,false)
	Legion2_SetSoundProfile(60,false)
	Legion2_SetSoundProfile(69,false)
	Legion2_SetSoundProfile(66,false)
	Legion2_SetSoundProfile(67,false)
	Legion2_SetSoundProfile(70,false)
	Legion2_SetSoundProfile(72,false)
	Legion2_SetSoundProfile(73,false)
	Legion2_SetSoundProfile(75,false)
	Legion2_SetSoundProfile(81,false)
	Legion2_SetSoundProfile(82,false)
	Legion2_SetSoundProfile(83,false)
	Legion2_SetSoundProfile(86,false)
	Legion2_SetSoundProfile(88,false)
	Legion2_SetSoundProfile(90,false)
	Legion2_SetSoundProfile(91,true)
	Legion2_SetSoundProfile(93,false)
	Legion2_SetSoundProfile(100,false)
	Legion2_SetSoundProfile(101,false)
	Legion2_SetSoundProfile(103,false)
	Legion2_SetSoundProfile(104,false)
	Legion2_SetSoundProfile(106,false)
	Legion2_SetSoundProfile(111,false)
	Legion2_SetSoundProfile(112,true)
	Legion2_SetSoundProfile(113,false)
	Legion2_SetSoundProfile(114,false)
	Legion2_SetSoundProfile(116,false)
	Legion2_SetSoundProfile(117,false)
	Legion2_SetSoundProfile(118,false)
	Legion2_SetSoundProfile(119,false)
	Legion2_SetSoundProfile(120,false)
	Legion2_SetSoundProfile(121,false)
	Legion2_SetSoundProfile(122,false)
	Legion2_SetSoundProfile(123,false)
	Legion2_SetSoundProfile(125,false)
	Legion2_SetSoundProfile(129,false)
	Legion2_SetSoundProfile(130,false)
	Legion2_SetSoundProfile(133,false)
	Legion2_SetSoundProfile(136,false)
	Legion2_SetSoundProfile(137,false)
	Legion2_SetSoundProfile(139,false)
	Legion2_SetSoundProfile(140,false)
	Legion2_SetSoundProfile(141,false)
	Legion2_SetSoundProfile(142,false)
	Legion2_SetSoundProfile(143,false)
	Legion2_SetSoundProfile(144,false)
	Legion2_SetSoundProfile(145,false)
	Legion2_SetSoundProfile(147,false)
	Legion2_SetSoundProfile(148,false)
	Legion2_SetSoundProfile(150,false)
	Legion2_SetSoundProfile(156,false)
	Legion2_SetSoundProfile(153,false)
	Legion2_SetSoundProfile(161,false)
	
	Legion2_SetSoundProfile(132,false)
	Legion2_SetSoundProfile(110,false)
	Legion2_SetSoundProfile(102,false)
	
	Legion2_SetSoundProfile(138,false)
	
	Legion2_SetSoundProfile(80,false)
	
	-- Informator
	Legion2_SetSoundProfile(107,false)
	
	-- Krwawy Tygrys
	Legion2_SetSoundProfile(108,false)
	
	-- P4
	Legion2_SetSoundProfile(105,false)
	
	-- L3
	Legion2_SetSoundProfile(115,false)
	
	Legion2_SetSoundProfile(109,false)
	
	Legion2_SetSoundProfile(124,false)
	
	-- C7
	Legion2_SetSoundProfile(97,false)

	-- Zablokuj przyciski na mapie strategicznej
	SetGlobalTrue(25) -- BorderTown
	SetGlobalFalse(26) -- BorderMine
	SetGlobalTrue(27) -- BorderTeams
	SetGlobalFalse(28) -- BorderMilitia
	SetGlobalFalse(29) -- BorderAirspace
	SetGlobalTrue(30) -- BorderItem

end

local function ResetValue()

-- Resetuj wrogie grupy.
for i = 0,255 do
	for p = 0,254 do
		Legion2_SetTacticalStatusGroupAttack(i,p,0) -- (0) CIV_GROUP_NEUTRAL
	end
end
	
-- Ustaw zawsze wrogie grupy.
for i = 0,255 do
	Legion2_SetTacticalStatusGroupAttack(i,58,3) -- CIV_GROUP_HOSTILE(3) UNNAMED_CIV_GROUP_58
	Legion2_SetTacticalStatusGroupAttack(i,29,3) -- CIV_GROUP_HOSTILE(3) UNNAMED_CIV_GROUP_29
	Legion2_SetTacticalStatusGroupAttack(i,49,3) -- CIV_GROUP_HOSTILE(3) UNNAMED_CIV_GROUP_49
	Legion2_SetTacticalStatusGroupAttack(i,34,3) -- CIV_GROUP_HOSTILE(3) UNNAMED_CIV_GROUP_34
	Legion2_SetTacticalStatusGroupAttack(i,75,3) -- CIV_GROUP_HOSTILE(3) UNNAMED_CIV_GROUP_75
	Legion2_SetTacticalStatusGroupAttack(i,65,3) -- CIV_GROUP_HOSTILE(3) UNNAMED_CIV_GROUP_65
end

Legion2_SetTacticalStatusGroupAttack(SECTOR ( 7, 3 ),58,0) -- CIV_GROUP_HOSTILE(3) UNNAMED_CIV_GROUP_58

end

function InitStrategicLayer()
local o,p


	-- Ustaw losowy sektor przybycia najemników oraz ustaw ważne wartości globalne.
	
	--if (is_networked == 0 and 
	
	if (is_networked == 0) then 
	if ( newDIFFICULTY_LEVEL == DIF_LEVEL_INSANE or newDIFFICULTY_LEVEL == DIF_LEVEL_MEDIUM or newDIFFICULTY_LEVEL == DIF_LEVEL_HARD ) then
		o = math.random(1, 6)
		if o == 1 then
			-- K4
			SetDefaultArrivalSector( 4, SectorY.MAP_ROW_K )
			SetDefaultArrivalGridNo(7260)
			SetGlobalFalse(24)
			SetGlobalTrue(31)  -- plik 060_a.edt
			SetGlobalFalse(32) -- plik 060_b.edt
			SetGlobalTrue(98)  -- Alfred w Napol
			StartQuest( 33, 4, SectorY.MAP_ROW_K ) -- zadanie odszukaj Alfreda
			SetFactTrue( 464 ) -- pilot w L3
			SetGlobalTrue (122) -- pilot w L3
		elseif o == 2 then
			-- K4
			SetDefaultArrivalSector( 4, SectorY.MAP_ROW_K )
			SetDefaultArrivalGridNo(7260)
			SetGlobalFalse(24)
			SetGlobalTrue(31)  -- plik 060_a.edt
			SetGlobalFalse(32) -- plik 060_b.edt
			SetGlobalTrue(98)  -- Alfred w Napol
			StartQuest( 33, 4, SectorY.MAP_ROW_K ) -- zadanie odszukaj Alfreda
			SetFactTrue( 464 ) -- pilot w L3
			SetGlobalTrue (122) -- pilot w L3
		elseif o == 3 then	
			-- M5
			SetDefaultArrivalSector( 5, SectorY.MAP_ROW_M )
			SetDefaultArrivalGridNo(6780)
			SetGlobalTrue(24)
			SetGlobalFalse(31) -- plik 060_a.edt
			SetGlobalFalse(32) -- plik 060_b.edt
			SetGlobalTrue(37)  -- Alfred w K6
			StartQuest( 33, 5, SectorY.MAP_ROW_M ) -- zadanie odszukaj Alfreda
			SetFactTrue( 464 ) -- pilot w L3
			SetGlobalTrue (122) -- pilot w L3
		elseif o == 4 then
			-- L5
			SetDefaultArrivalSector( 5, SectorY.MAP_ROW_L )
			SetDefaultArrivalGridNo(6940)
			SetGlobalFalse(24) 
			SetGlobalTrue(31)  -- plik 060_a.edt
			SetGlobalFalse(32) -- plik 060_b.edt
			SetGlobalTrue(98)  -- Alfred w Napol
			StartQuest( 33, 5, SectorY.MAP_ROW_L ) -- zadanie odszukaj Alfreda
			SetFactTrue( 464 ) -- pilot w L3
			SetGlobalTrue (122) -- pilot w L3
		elseif o == 5 then
			-- L4
			SetDefaultArrivalSector( 4, SectorY.MAP_ROW_L )
			SetDefaultArrivalGridNo(4084)
			SetGlobalFalse(24) 
			SetGlobalTrue(31)  -- plik 060_a.edt
			SetGlobalFalse(32) -- plik 060_b.edt
			SetGlobalTrue(98)  -- Alfred w Napol
			StartQuest( 33, 4, SectorY.MAP_ROW_L ) -- zadanie odszukaj Alfreda
			SetFactTrue( 464 ) -- pilot w L3
			SetGlobalTrue (122) -- pilot w L3
		elseif o == 6 then
			-- M6
			SetDefaultArrivalSector( 6, SectorY.MAP_ROW_M )
			SetDefaultArrivalGridNo(8531)
			SetGlobalFalse(24) 
			SetGlobalTrue(99)  -- Alfred w Sektorze K8 (Wartownia)
		    SetGlobalFalse(37) -- Alfred w K6 było  true
			SetGlobalTrue(32)  -- plik 060_b.edt
			SetGlobalFalse(31) -- plik 060_a.edt
			StartQuest( 33, 6, SectorY.MAP_ROW_M ) -- zadanie odszukaj Alfreda
			SetFactTrue( 464 ) -- pilot w L3
			SetGlobalTrue (122) -- pilot w L3
		end
	elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_EASY ) then
		p = math.random(1, 100)
		if ( p >= 50 ) then
			-- K6
			SetDefaultArrivalSector( 6, SectorY.MAP_ROW_K )
			SetDefaultArrivalGridNo(11097)
			SetGlobalFalse(24) 
			SetGlobalTrue(37)  -- Alfred w K6
			SetGlobalFalse(31) -- plik 060_a.edt
			SetGlobalFalse(32)  -- plik 060_b.edt
			SetFactFalse( 464 )
			SetGlobalFalse (122)
		else
			-- K4
			SetDefaultArrivalSector( 4, SectorY.MAP_ROW_K )
			SetDefaultArrivalGridNo(7260)
			SetGlobalTrue(24)  -- losowy mail. Pilot wysadził najemników w sektorze K4.
			SetGlobalTrue(37)  -- Alfred w K6
			SetGlobalFalse(31) -- plik 060_a.edt
			SetGlobalFalse(32)  -- plik 060_b.edt
			StartQuest( 33, 4, SectorY.MAP_ROW_K ) -- zadanie odszukaj Alfreda
			SetFactTrue( 464 ) -- pilot w L3
			SetGlobalTrue (122) -- pilot w L3
		end
	end
  end
  
  if (is_networked == 1) then 
			-- K6
			SetDefaultArrivalSector( 6, SectorY.MAP_ROW_K )
			SetDefaultArrivalGridNo(11097)
			SetGlobalFalse(24) 
			SetGlobalTrue(37)  -- Alfred w K6
			SetGlobalFalse(31) -- plik 060_a.edt
			SetGlobalFalse(32)  -- plik 060_b.edt
			SetFactFalse( 464 )
			SetGlobalFalse (122)
  end
  
end

function InitNPCs()

	ResetNPCSector()

	SetFactFalse( 377 )  -- FACT_KARLOS_ZABITY
	SetFactTrue( 468 )
	
	-- Czytaj pliki profilów z katalogu "TableData\Profile\Aim"
	for i = 0,39 do
		Legion2_LoadAimIni(i,AltIniFile.None)		
	end	
			
	-- Czytaj pliki profilów z katalogu "TableData\Profile\Merc"
	for i = 40,50 do
		Legion2_LoadMercIni(i,AltIniFile.None)		
	end	
		
	-- Ustaw wybrane profile z katalogu "TableData\Profile\NPC"
	Legion2_LoadNpcIni(60,AltIniFile.None)	-- Alfred	
	Legion2_LoadNpcIni(59,AltIniFile.None)	-- Ira
	Legion2_LoadNpcIni(69,AltIniFile.None)	-- Rainman
	Legion2_LoadNpcIni(70,AltIniFile.None)	-- Prot
	Legion2_LoadNpcIni(73,AltIniFile.None)	-- Bobi
	Legion2_LoadNpcIni(75,AltIniFile.None)	-- General2
	Legion2_LoadNpcIni(83,AltIniFile.None)	-- Chris
	Legion2_LoadNpcIni(82,AltIniFile.None)	-- D7
	Legion2_LoadNpcIni(81,AltIniFile.None)	-- B4
	Legion2_LoadNpcIni(90,AltIniFile.None)	-- Haker
	Legion2_LoadNpcIni(91,AltIniFile.None)	-- Tony
	Legion2_LoadNpcIni(100,AltIniFile.None)	-- Father
	Legion2_LoadNpcIni(101,AltIniFile.None)	-- Fatima
	Legion2_LoadNpcIni(103,AltIniFile.None)	-- Gordon
	Legion2_LoadNpcIni(104,AltIniFile.None)	-- B4
	--Legion2_LoadNpcIni(106,AltIniFile.None) -- Kopalnia
	Legion2_LoadNpcIni(111,AltIniFile.None)	-- Alex
	Legion2_LoadNpcIni(112,AltIniFile.None)	-- f12/n10
	Legion2_LoadNpcIni(113,AltIniFile.None)	-- B4
	Legion2_LoadNpcIni(114,AltIniFile.None)	-- Pacos
	Legion2_LoadNpcIni(116,AltIniFile.None)	-- Marynarz
	Legion2_LoadNpcIni(118,AltIniFile.None)	-- John
	Legion2_LoadNpcIni(117,AltIniFile.None)	-- Alfred 2
	Legion2_LoadNpcIni(119,AltIniFile.None) -- Mary
	Legion2_LoadNpcIni(120,AltIniFile.None) -- General
	Legion2_LoadNpcIni(121,AltIniFile.None) -- Jax
	Legion2_LoadNpcIni(122,AltIniFile.None) -- Armando
	Legion2_LoadNpcIni(123,AltIniFile.None) -- Nauczycielka
	Legion2_LoadNpcIni(125,AltIniFile.None) -- Naukowiec
	Legion2_LoadNpcIni(129,AltIniFile.None) -- Lora
	Legion2_LoadNpcIni(130,AltIniFile.None) -- EPC
	Legion2_LoadNpcIni(133,AltIniFile.None) -- Oficer
	Legion2_LoadNpcIni(136,AltIniFile.None) -- Dereek
	Legion2_LoadNpcIni(137,AltIniFile.None) -- Oswald
	Legion2_LoadNpcIni(139,AltIniFile.None) -- Dr. Clifo
	Legion2_LoadNpcIni(141,AltIniFile.None) 
	Legion2_LoadNpcIni(142,AltIniFile.None) 
	Legion2_LoadNpcIni(143,AltIniFile.None) -- Marcus
	Legion2_LoadNpcIni(144,AltIniFile.None) -- Olga
	Legion2_LoadNpcIni(145,AltIniFile.None) -- Tyrone\Freddy
	Legion2_LoadNpcIni(147,AltIniFile.None) -- Sierzant
	--Legion2_LoadNpcIni(148,AltIniFile.None) -- Kopalnia
	Legion2_LoadNpcIni(150,AltIniFile.None) -- Flint
	Legion2_LoadNpcIni(156,AltIniFile.None) -- b4
	Legion2_LoadNpcIni(153,AltIniFile.None) -- Alberto
	Legion2_LoadNpcIni(161,AltIniFile.None) -- ElDorado
	
	-- Policja
	Legion2_LoadNpcIni(102,AltIniFile.None) -- Policja
	Legion2_LoadNpcIni(110,AltIniFile.None) -- Policja
	Legion2_LoadNpcIni(132,AltIniFile.None) -- Policja
	
	-- C7
	Legion2_LoadNpcIni(97,AltIniFile.None) -- Pilot
	
	-- L3
	Legion2_LoadNpcIni(80,AltIniFile.None) -- Straż graniczna
	
	Legion2_LoadNpcIni(138,AltIniFile.None) -- Waldo
	
	Legion2_LoadNpcIni(107,AltIniFile.None) -- Informator
	
	-- M3-b1
	Legion2_LoadNpcIni(108,AltIniFile.None) -- Krwawy Tygrys
	
	-- P4
	Legion2_LoadNpcIni(105,AltIniFile.None) -- P4
	
	Legion2_LoadNpcIni(115,AltIniFile.None) -- L3
	
	Legion2_LoadNpcIni(109,AltIniFile.None)
	
	Legion2_LoadNpcIni(124,AltIniFile.None) -- Jerry
	
	-- Ustaw alternatywne pliki profilów ( *_a.ini, *_b.ini, *_c.ini ) z katalogu "TableData\Profile\NPC"
	-- Ustaw inne ważne wartości globalne.
	if ( newDIFFICULTY_LEVEL == DIF_LEVEL_EASY) then
		i = math.random(1, 100)
		if (i >=50) then
			Legion2_LoadNpcIni(66,AltIniFile.Alt_A)	-- Jack		066_a.ini
			Legion2_LoadNpcIni(93,AltIniFile.Alt_A) -- Spike	093_a.ini
				
			--sUSTAW[7] = TRUE; 
			--sUSTAW[6] = TRUE; 
			--sUSTAW[8] = TRUE; 
			SetGlobalTrue (8) -- gadanie Spika
			SetGlobalTrue (7) -- Spike
			SetGlobalTrue (6) -- Jack
		else
			Legion2_LoadNpcIni(66,AltIniFile.None) -- Jack	066.ini
			Legion2_LoadNpcIni(93,AltIniFile.None) -- Spike	093.ini
					
			SetGlobalFalse (7) -- Spike
			SetGlobalFalse (6) -- Jack
			SetGlobalFalse (8) -- gadanie Spika
			--sUSTAW[7] = FALSE;
			--sUSTAW[6] = FALSE;
			--sUSTAW[8] = FALSE;
		end
	elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_MEDIUM )then
			Legion2_LoadNpcIni(66,AltIniFile.Alt_A)	-- Jack	 066_a.ini
			Legion2_LoadNpcIni(93,AltIniFile.Alt_A) -- Spike 093_a.ini	
			
			SetGlobalFalse (7) -- Spike
			SetGlobalFalse (6) -- Jack
			SetGlobalFalse (8) -- gadanie Spika
			--sUSTAW[7] = FALSE;
			--sUSTAW[6] = FALSE;
			--sUSTAW[8] = FALSE;
	elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_HARD )then
		i = math.random(1, 100)
		if (i >=50) then
			Legion2_LoadNpcIni(66,AltIniFile.Alt_A)	-- Jack	 066_a.ini
			Legion2_LoadNpcIni(93,AltIniFile.Alt_A) -- Spike 093_a.ini	
				
			--sUSTAW[7] = TRUE; 
			--sUSTAW[6] = TRUE; 
			--sUSTAW[8] = TRUE; 
			SetGlobalTrue (8) -- gadanie Spika
			SetGlobalTrue (7) -- Spike
			SetGlobalTrue (6) -- Jack
		else
			Legion2_LoadNpcIni(66,AltIniFile.None) -- Jack	066.ini
			Legion2_LoadNpcIni(93,AltIniFile.None) -- Spike	093.ini
						
			SetGlobalFalse (7) -- Spike
			SetGlobalFalse (6) -- Jack
			SetGlobalFalse (8) -- gadanie Spika
			--sUSTAW[7] = FALSE;
			--sUSTAW[6] = FALSE;
			--sUSTAW[8] = FALSE;
		end
	elseif( newDIFFICULTY_LEVEL == DIF_LEVEL_INSANE )then
		i = math.random(1, 100)
		if (i >=50) then
			Legion2_LoadNpcIni(66,AltIniFile.Alt_A)	-- Jack	 066_a.ini
			Legion2_LoadNpcIni(93,AltIniFile.Alt_A) -- Spike 093_a.ini	
				
			--sUSTAW[7] = TRUE; 
			--sUSTAW[6] = TRUE; 
			--sUSTAW[8] = TRUE; 
			SetGlobalTrue (8) -- gadanie Spika
			SetGlobalTrue (7) -- Spike
			SetGlobalTrue (6) -- Jack
		else
			Legion2_LoadNpcIni(66,AltIniFile.None) -- Jack	066.ini
			Legion2_LoadNpcIni(93,AltIniFile.None) -- Spike	093.ini
			
			SetGlobalFalse (7) -- Spike
			SetGlobalFalse (6) -- Jack
			SetGlobalFalse (8) -- gadanie Spika
			--sUSTAW[7] = FALSE;
			--sUSTAW[6] = FALSE;
			--sUSTAW[8] = FALSE;
		end
	end
	
		-- Wylosuj Maksa. 
		i = math.random(1, 100)
		if (i >=50) then
			--sUSTAW[0] = TRUE;
			SetGlobalTrue (0)
			Legion2_LoadNpcIni(72,AltIniFile.None) -- Max	072.ini
		else
			--sUSTAW[0] = FALSE;
			SetGlobalFalse (0)
			Legion2_LoadNpcIni(72,AltIniFile.Alt_A) -- Max	072_a.ini
		end
		
		-- Wylosuj 112.ini
		i = math.random(1, 100)
		if (i >=50) then
			Legion2_LoadNpcIni(112,AltIniFile.None) -- 112.ini	
			AddAltSectorNew( 10, SectorY.MAP_ROW_N )
		else
			Legion2_LoadNpcIni(112,AltIniFile.Alt_A) -- 112_a.ini
			AddAltSectorNew( 12, SectorY.MAP_ROW_F )    
		end
		
		-- Wylosuj kleryka i Maverika lub tylko kleryka. 
		i = math.random(1, 100)
		if (i >=50) then
			Legion2_LoadNpcIni(57,AltIniFile.None) -- Kleryk  057.ini	
			Legion2_LoadNpcIni(67,AltIniFile.None) -- Maveric 067.ini					
		else
			Legion2_LoadNpcIni(57,AltIniFile.Alt_A) -- Kleryk 057_a.ini			
		end
			
	-- Postacie losowane w zależności od wyboru ilości dni do ukończenia głównego zadania.
	if ( Legion2_GameEndDay == 0 ) then  -- 15
	
		i = math.random(1, 3)
		if ( i == 1 ) then
			Legion2_LoadNpcIni(88,AltIniFile.Alt_B)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_B) -- Strażnik Bob		
			-- rem Legion2_LoadNpcIni(86,AltIniFile.Alt_A)	 -- Karlos
			
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,2)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,2) -- Strażnik Bob	
			-- rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,2)  -- Karlos

			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;			
		elseif ( i == 2 ) then
			Legion2_LoadNpcIni(88,AltIniFile.Alt_C)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_C) -- Strażnik Bob	
			Legion2_LoadNpcIni(90,AltIniFile.Alt_A)	 -- Haker			
		
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,3)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,3) -- Strażnik Bob
			AddNPCtoSector(90 ,8 ,SectorY.MAP_ROW_C ,0)  -- Haker

			SetGlobalFalse (1) -- Alternatywny plik Chrisa			
			-- sUSTAW[1] = FALSE; //Alternatywny plik Chrisa				
		elseif ( i == 3 ) then
			Legion2_LoadNpcIni(88,AltIniFile.Alt_C)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_C) -- Strażnik Bob	
			-- rem Legion2_LoadNpcIni(86,AltIniFile.Alt_B)	 -- Karlos		
			Legion2_LoadNpcIni(90,AltIniFile.Alt_B)	 -- Haker			
		
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,3)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,3) -- Strażnik Bob
			--rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,3)  -- Karlos
			AddNPCtoSector(90 ,2 ,SectorY.MAP_ROW_E ,3)  -- Haker
	
			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;			
		end
		
	elseif ( Legion2_GameEndDay == 1 ) then -- 25 
	
		i = math.random(1, 100)
		if ( i >=50 ) then
			Legion2_LoadNpcIni(88,AltIniFile.Alt_B)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_B) -- Strażnik Bob	
			--rem Legion2_LoadNpcIni(86,AltIniFile.Alt_A)	 -- Karlos	
			
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,2)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,2) -- Strażnik Bob
			--rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,2)  -- Karlos

			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;
		else
			Legion2_LoadNpcIni(88,AltIniFile.Alt_C)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_C) -- Strażnik Bob	
			--rem Legion2_LoadNpcIni(86,AltIniFile.Alt_B)	 -- Karlos			
		
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,3)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,3) -- Strażnik Bob
			--rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,3)  -- Karlos

			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;
		end
		
	elseif ( Legion2_GameEndDay == 2 ) then	-- 30
		i = math.random(1, 100)
		if ( i >=50 ) then
			Legion2_LoadNpcIni(88,AltIniFile.Alt_B)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_B) -- Strażnik Bob	
			-- rem Legion2_LoadNpcIni(86,AltIniFile.Alt_A)	 -- Karlos				
		
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,2)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,2) -- Strażnik Bob
			--rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,2)  -- Karlos

			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;
		else
			Legion2_LoadNpcIni(88,AltIniFile.Alt_B)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_B) -- Strażnik Bob	
			Legion2_LoadNpcIni(90,AltIniFile.Alt_A)  -- haker		
		
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,2)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,2) -- Strażnik Bob
			AddNPCtoSector(86 ,8 ,SectorY.MAP_ROW_C ,0)  -- Haker

			SetGlobalFalse (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = FALSE;
		end	
	elseif ( Legion2_GameEndDay == 3 ) then -- 40
		i = math.random(1, 100)
		if ( i >=50 ) then
			Legion2_LoadNpcIni(88,AltIniFile.Alt_C)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_C) -- Strażnik Bob	
			--rem Legion2_LoadNpcIni(86,AltIniFile.Alt_B)	 -- Karlos	

			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,3)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,3) -- Strażnik Bob
			--rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,3)  -- Karlos
			
			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;
		else
			Legion2_LoadNpcIni(88,AltIniFile.Alt_B)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_B) -- Strażnik Bob	
			Legion2_LoadNpcIni(90,AltIniFile.Alt_B)     -- haker	
			
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,2)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,2) -- Strażnik Bob
			AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,3)  -- Haker

			SetGlobalFalse (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = FALSE;
		end		
	elseif ( Legion2_GameEndDay == 4 ) then -- brak
		i = math.random(1, 100)
		if ( i >=50 ) then
			Legion2_LoadNpcIni(88,AltIniFile.Alt_B)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_B) -- Strażnik Bob	
			Legion2_LoadNpcIni(90,AltIniFile.Alt_A)  -- haker
			--rem Legion2_LoadNpcIni(86,AltIniFile.Alt_A)	 -- Karlos	
			
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,2)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,2) -- Strażnik Bob
			--rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,2)  -- Karlos
			AddNPCtoSector(86 ,8 ,SectorY.MAP_ROW_C ,0)  -- Haker

			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;
		else
			Legion2_LoadNpcIni(88,AltIniFile.Alt_C)	 -- Maria
			Legion2_LoadNpcIni(140,AltIniFile.Alt_C) -- Strażnik Bob	
			-- rem Legion2_LoadNpcIni(86,AltIniFile.Alt_B)	 -- Karlos			
		
			AddNPCtoSector(88 ,2 ,SectorY.MAP_ROW_E ,3)  -- Maria
			AddNPCtoSector(140 ,2 ,SectorY.MAP_ROW_E ,3) -- Strażnik Bob
			--rem AddNPCtoSector(86 ,2 ,SectorY.MAP_ROW_E ,3)  -- Karlos
	
			SetGlobalTrue (1) -- Alternatywny plik Chrisa	
			-- sUSTAW[1] = TRUE;
		end		
	end
	
	-- Ustaw globalną. Czy doda zdjęcie do inwentarza Alfreda.
	SetGlobalTrue (38) -- Zdjęcie dla Alfreda
	
	-- Patrz funkcja wyżej
	SetValue() -- local function
	
	-- Patrz funkcja wyżej
	ResetValue() -- local function
		
	-- Init hospital variables
	HospitalTempBalance( 0 )
	HospitalRefund( 0 )
	HospitalPriceModifier( Modifier.HOSPITAL_UNSET )

	-- Set up Devin so he will be placed
	SetNPCData1 ( Profil.Devin, 3 )
end

function InitNewGame()
local KASA
local o  
local i
local a
local b
	
	-- Włącz\Wyłącz Specka
	SetGlobalFalse (103)
	
	-- Sprzedany Pacos
	SetGlobalTrue (449)
	
	
	
	-- Legion2_LoadSavePatch.lua
	-- powiązane z łatką 01
	SetGlobalTrue (500)	
	
	-- powiązane z łatką 02
	SetGlobalTrue (502)	
	SetGlobalTrue (503)	-- nowe punkty zrzutu
	
	-- powiązane z łatką 03
	SetGlobalTrue (504)
	SetGlobalTrue (506)
	SetGlobalTrue (507)
	
	-- powiązane z łatką 04
	SetGlobalTrue (508)
	
	-- powiązane z łatką 05
	SetGlobalTrue (509)
	
	-- powiązane z łatką 06
	SetGlobalTrue (510)
	
	-- powiązane z łatką 09
	SetGlobalTrue (511)
	SetGlobalTrue (512)
	SetGlobalTrue (513)
	
	-- powiązane z łatką 10
	SetGlobalTrue (514)
	
	-- 13-11-2013 r1870
	SetGlobalTrue (515)
	
	-- Gdy "false" wczytaj starą mapę np. E2.dat tylko dla starych zapisów gry.
	-- Gdy "true " wczytaj dla nowej gry nową mapę np. E2_new_map.dat
	-- Zostawić "true" !
	Legion2_AltNewMap (2,5, true) -- E2
	Legion2_AltNewMap (8,4, true) -- D8_b1
	Legion2_AltNewMap (7,4, true) -- D7
	
	-- Speck
	if ( CheckGlobalBool(103) == true ) then
		SetMercStatus ( 191, -7 )
	end
	

	  if ( is_networked == 0 ) then
	  
	    -- Powitanie 
		AddEmail (232, 7, 51, -1, -1)
		
		-- Mail powiązany z głównym zadaniem
		if ( Legion2_BriefingRoom == true ) then
			AddEmail (321, 3, 50, -1, -1) -- Misja AIM (1)
		end
		
		-- Mail IMP
		AddEmail (IMP_EMAIL_INTRO, IMP_EMAIL_INTRO_LENGTH, Sender.CHAR_PROFILE_SITE, -1, -1)
		
		if( iniMERC_WEBSITE_IMMEDIATELY_AVAILABLE == true ) then
			AddEmail (MERC_INTRO, MERC_INTRO_LENGTH, Sender.SPECK_FROM_MERC, -1, -1)
		end
	end
	
		-- Losuj dodatkowe fundusze. Zależy od wybrania stopnia trudności gry.
		i = math.random(1, 4)
		if (i == 1) then
			KASA = 2*1500
		elseif (i == 2) then
			KASA = 2*2000
		elseif (i == 3) then
			KASA = 2*2500
		elseif (i == 4) then
			KASA = 2*3000
		end
		
	-- Ustaw ilość funduszy. Zależy od wybrania stopnia trudności gry.
	if ( newDIFFICULTY_LEVEL == DIF_LEVEL_EASY ) then
		iStartingCash = 45000 + KASA
	elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_MEDIUM ) then
		iStartingCash = 35000 + KASA
	elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_HARD ) then	
		iStartingCash = 25000 + KASA
	elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_INSANE ) then
		iStartingCash = 15000 + KASA
	end
	
	-- Ustaw zakończenie głównego zadania. Legion2_iniEndDay0 - Legion2_iniEndDay3 są wartościami pobranymi z pliku "Legion2_Options.ini".
	-- Wartość "200" zawsze oznacza nieskończoną ilość czasu.
	if ( Legion2_GameEndDay == 0 ) then
		Legion2_SetEndDay (Legion2_iniEndDay0) -- 15
		SetGlobalVal(301,3) -- Stracony kontak z Alfredem.
		SetGlobalVal(302,4) -- Informator.
		SetGlobalVal(303,6) -- Maria do innego sektora.
		SetGlobalVal(304,2) -- Maria ponownie do innego sektora.
	elseif ( Legion2_GameEndDay == 1 ) then
		Legion2_SetEndDay (Legion2_iniEndDay1) -- 25
		SetGlobalVal(301,5) -- Stracony kontak z Alfredem.
		SetGlobalVal(302,6) -- Informator.
		SetGlobalVal(303,8) -- Maria do innego sektora.
		SetGlobalVal(304,3) -- Maria ponownie do innego sektora.
	elseif ( Legion2_GameEndDay == 2 ) then	
		Legion2_SetEndDay (Legion2_iniEndDay2) -- 30
		SetGlobalVal(301,5) -- Stracony kontak z Alfredem
		SetGlobalVal(302,7) -- Informator
		SetGlobalVal(303,9) -- Maria do innego sektora
		SetGlobalVal(304,3) -- Maria ponownie do innego sektora.
	elseif ( Legion2_GameEndDay == 3 ) then
		Legion2_SetEndDay (Legion2_iniEndDay3) -- 40
		SetGlobalVal(301,7)  -- Stracony kontak z Alfredem
		SetGlobalVal(302,9)  -- Informator
		SetGlobalVal(303,10) -- Maria do innego sektora
		SetGlobalVal(304,2)  -- Maria ponownie do innego sektora.
	elseif ( Legion2_GameEndDay == 4 ) then
		Legion2_SetEndDay (200)
		SetGlobalVal(301,5) -- Stracony kontak z Alfredem
		SetGlobalVal(302,7) -- Informator
		SetGlobalVal(303,9) -- Maria do innego sektora
		SetGlobalVal(304,2) -- Maria ponownie do innego sektora.
	end
	
	-- Ustaw zakończenie głównego zadania. Funkcja "Legion2_GetEndDay()" pobiera wartość która jest ustwaiona przez funkcje "Legion2_SetEndDay (ilość dni)"
	AddFutureDayStrategicEvent( 81, 60*7, 0, Legion2_GetEndDay() )
	
		  -- Jeżeli pilot nie doleciał, dostaniemy wiadomość od Oswalda
          if ( CheckGlobalBool(24) == true ) then
			 AddEmail (274, 3, 53, -1, -1) -- Oswald
          end
		  
		  -- Alternatywan wiadomość od Oswalda.
          if ( CheckGlobalBool(98) == true ) then
			 AddEmail (329, 4, 53, -1, -1) -- Oswald
			 AddAltSectorNew( 6, SectorY.MAP_ROW_K)  
          end
		  
		  -- Alternatywan wiadomość od Oswalda.
          if ( CheckGlobalBool(99) == true ) then
			 AddEmail (334, 4, 53, -1, -1) -- Oswald
			 AddAltSectorNew( 6, SectorY.MAP_ROW_K)  
          end
		  
		 -- Dodaj zdjęcie do inwentarza Alfreda.
		 MercProfileSetPOCKPOS (60,0,4503,1,100,1,10)
		  
	-- Losowy Alfred w Napol
	if ( CheckGlobalBool(98) == true ) then
		
		a = math.random(1, 100)
		if (a >=50) then
			AddNPCtoSector(60 ,12 ,SectorY.MAP_ROW_G ,0)  -- Alfred
		else
			AddNPCtoSector(60 ,12 ,SectorY.MAP_ROW_F ,0)  -- Alfred
		end
		-- ustaw dwa dni na odnalezienie Alfreda
		-- SetFactTrue( Facts.FACT_ILOSC_DNI_DO_KONCA_15 )
		-- Legion2_SetEndDay (2)
	end
	
	-- Alfred w wartowni K8
	if ( CheckGlobalBool(99) == true ) then
		AddNPCtoSector(60 ,8 ,SectorY.MAP_ROW_K ,0)  -- Alfred
		
		-- ustaw dwa dni na odnalezienie Alfreda
		-- SetFactTrue( Facts.FACT_ILOSC_DNI_DO_KONCA_15 )
		-- Legion2_SetEndDay (2)
	end
	
	-- Wylosuj Rain Mana
		b = math.random(1, 100)
		if (b >=70) then
			AddNPCtoSector(69 ,8 ,SectorY.MAP_ROW_D ,0)  -- Rain Man
			SetGlobalTrue (48)
			SetFactTrue( 431 )
		else
			AddNPCtoSector(69 ,0 ,0 ,0)  -- Rain Man
			SetGlobalFalse (48)
			SetFactFalse( 431 )
		end
	
	-- Alfred w K6
	if ( CheckGlobalBool(37) == true ) then
		AddNPCtoSector(60 ,6 ,SectorY.MAP_ROW_K ,0)  -- Alfred
	end
	
	-- Jerry
	if ( CheckGlobalBool(122) == true ) then
		--Legion2_LoadNpcIni(124,AltIniFile.None) 
		AddNPCtoSector(124 ,3 ,SectorY.MAP_ROW_L ,0) 
	else
		AddNPCtoSector(124 ,0 ,0 ,0) 
		--Legion2_LoadNpcIni(124,AltIniFile.Alt_A) 
	end
	
	-- Załadowanie konta co 5 dni.
	if ( Legion2_GameEndDay == 0 ) then
		AddFutureDayStrategicEvent( 92, 60*7, 0, 4 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 9 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 14 )
	elseif ( Legion2_GameEndDay == 1 ) then
		AddFutureDayStrategicEvent( 92, 60*7, 0, 4 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 9 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 14 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 24 )
	elseif ( Legion2_GameEndDay == 2 ) then	
		AddFutureDayStrategicEvent( 92, 60*7, 0, 4 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 9 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 14 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 21 )			
		AddFutureDayStrategicEvent( 92, 60*7, 0, 26 )
	elseif ( Legion2_GameEndDay == 3 ) then
		AddFutureDayStrategicEvent( 92, 60*7, 0, 4 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 9 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 14 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 21 )				
		AddFutureDayStrategicEvent( 92, 60*7, 0, 26 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 31 )
		AddFutureDayStrategicEvent( 92, 60*7, 0, 36 )
	elseif ( Legion2_GameEndDay == 4 ) then
		for i = 0,999 do
			if (i > 0 ) then AddFutureDayStrategicEvent( 92, 60*7, 0, 4*i ) end
		end
	end
	
	if ( LEGION2_HARD == true ) then
		AddFutureDayStrategicEvent( 100, 60*7, 1, 3 )
		AddFutureDayStrategicEvent( 100, 60*7, 2, 7 )
		AddFutureDayStrategicEvent( 100, 60*7, 3, 10 )
	end
	
		-- Zdarzenia związane z hakerem. Załadowanie konta co 5 dni.
		for i = 0,999 do
			AddFutureDayStrategicEvent( 96, 60*7, 0, 5*i )
		end
		
	-- Ustaw losowe wyłączenie połączenia z internetem. Tylko dla HARD i INSANE.
	if ( WYL_LAPTOP == true and ( newDIFFICULTY_LEVEL == DIF_LEVEL_HARD or newDIFFICULTY_LEVEL == DIF_LEVEL_INSANE ) ) then
		AddAdvancedStrategicEvent( 3, 97, 60*7, 0 )
	end
	
	-- Zadanie - Odszukaj Alfreda
	if ( CheckQuest (33) == qStatus.QUESTINPROGRESS ) then
		AddFutureDayStrategicEvent( 102, 60*7, 0, 2 )
		AddAdvancedStrategicEvent( 3, 103, 60*7, 0 )
	end
	
	-- Alfreda umarł
	AddAdvancedStrategicEvent( 3, 108, 60*7, 0 )
	
	-- Stracony kontakt z Alfredem
	AddAdvancedStrategicEvent( 3, 109, 60*7, 0 )
	
	-- Informator
	AddAdvancedStrategicEvent( 3, 110, 60*7, 0 )
	
	-- Przeniesiona Maria. 
	AddAdvancedStrategicEvent( 3, 111, 60*7, 0 )
	
	-- Ponowny transfer Marii do innego sektora. 
	AddAdvancedStrategicEvent( 3, 112, 60*7, 0 )
	
	-- emaile po uwolnieniu Marii
	AddAdvancedStrategicEvent( 3, 98, 60*7, 0 )
		
	-- naukowiec
	AddAdvancedStrategicEvent( 3, 99, GetWorldHour() + 60*7, 0 )
	
	-- Lora
	AddAdvancedStrategicEvent( 3, 104, GetWorldHour() + 60*7, 0 )
	
	-- Atakuj sektory
	AddAdvancedStrategicEvent( 3, 105, GetWorldHour() + 60*7, 0 )
		
	-- sektor L1 : Policja zlikwidowana zmiana planów Oslwalda. 
	AddAdvancedStrategicEvent( 3, 101, 60*7, 0 )
	
	-- Karlos w C7
	AddAdvancedStrategicEvent( 3, 106, 60*7, 0 )
	
	-- atak na puste sektory
	AddAdvancedStrategicEvent( 3, 107, 60*7, 0 )
		
	-- Funkcja dzikich kotów.
	AddBloodCats() -- local function
	
	-- Dodaj fundusze na konto.
	AddTransactionToPlayersBook( Fincances.ANONYMOUS_DEPOSIT, 0, GetWorldTotalMin(), iStartingCash )
	
	SetLaptopBroken (true)
	
	-- dodaj plecaki szturmowe, Patch 02
	
			for a=0,254 do
				-- sprawdza niezrekrutowanych najemników 
				if ( Legion2_InventorySystem == 1 and Legion2_CheckMercInventory(a, 10 ) == false and Legion2_CheckMercInventory(a, 11 ) == false ) then
					Legion2_AddMercInventory ( a, 10, 1098, 100, 1 )		 
				end
			end
		
end